
# Model configuration

Apros 6.05 contains a new module `Apros/Legacy` for manipulating the model configuration
with commands that are familiar to Apros 5 developers. Idea of the module is that
all Apros entities are referred by their names in the Apros solver.

## Updating model configuration

::value[Apros/Legacy/aadd, Apros/Legacy/aaddNonvisual, Apros/Legacy/amodi, Apros/Legacy/aconnect, Apros/Legacy/aconnectWithName]
::value[Apros/Legacy/ainclude, Apros/Legacy/aexclude, Apros/Legacy/arename]

## Examples

The following commands build a point-pipe-point configuration to subprocess MYDIAGRAM.

    import "Apros/Legacy" 
    aadd "MYDIAGRAM" "Point" "PO01" (50, 50)
    amodi "PO01" "PO11_PRESSURE" 0.2
    aexclude "PO01"
   
    aadd "MYDIAGRAM" "Point" "PO02" (100, 50)
    amodi "PO02" "PO11_PRESSURE" 0.1
    aexclude "PO02"
   
    aadd "MYDIAGRAM" "Pipe" "PIP01" (75, 50)
    amodi "PIP01" "PI12_CONNECT_POINT_1" "PO01"
    amodi "PIP01" "PI12_CONNECT_POINT_2" "PO02"

Alternatively `aconnect` can be used to create the same name reference connections:

    aconnect "PO01" "SelfPOINT" "PIP01" "PI12_CONNECT_POINT_1" 
    aconnect "PO02" "SelfPOINT" "PIP01" "PI12_CONNECT_POINT_2" 

Notice the attribute name "SelfPOINT" which represents the MODNAME terminal of the POINT module.
To make a reference to a module's MODNAME terminal, use "SelfMT" as the attribute name, where
MT is the module type name in uppercase.

## Making model queries

The module contains also the basic commands for making model queries:

::value[Apros/Legacy/ashow, Apros/Legacy/alist, Apros/Legacy/alistOnly, Apros/Legacy/aget, Apros/Legacy/amget, Apros/Legacy/amgetSort]
